<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">

                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>

                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i>
                            Hapus</button>
                        <table class="table table-bordered table-hover myTable tab mt-2">
                            <thead>
                                <tr>
                                    <th width="3%">No</th>
                                    <th>#</th>
                                    <th>Kode Member</th>
                                    <th>Nama Member</th>
                                    <th>Hp</th>
                                    <th>Email</th>
                                    <th>Username</th>
                                    <th>Jml. Poin</th>
                                    <th>Tukar Poin</th>
                                    <th>Belanja</th>
                                    <th>Tgl. Daftar</th>
                                    <th>Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($member as $m)
                                    @if ($m->kd_member == '0')
                                    @else
                                        <tr>
                                            <td class="text-center"> {{ $no++ }}</td>
                                            <td class="text-center">
                                                <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                    <input type="checkbox" name="id[]" id="cek{{ $m->id }}"
                                                        class="ceklis" value="{{ $m->id }}">
                                                    <label for="cek{{ $m->id }}">
                                                    </label>
                                                </div>
                                            </td>
                                            <td>{{ $m->kd_member }}</td>
                                            <td>{{ $m->nm_member }}</td>
                                            <td>{{ $m->hp_member }}</td>
                                            <td>{{ $m->email_member }}</td>
                                            <td>{{ $m->username }}</td>
                                            <td class="text-center">{{ poinmasuk($m->id) - poinkeluar($m->id) }}</td>
                                            <td class="text-center">{{ poinkeluar($m->id) }}</td>
                                            <td class="text-center">{{ belanja($m->id) }} Trasn</td>
                                            <td>{{ tgl_inf($m->created_at) }} </td>
                                            <td class="text-center">
                                                <button class="btn btn-info detail" data-id="{{ $m->id }}"> <i
                                                        class="fa fa-search mr-2"></i>
                                                    Detail</button>

                                            </td>
                                        </tr>
                                    @endif
                                @empty
                                    <tr>
                                        <td colspan="12" class="text-center text-danger"> Data
                                            masih
                                            kosong.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $member->links('components.admin.pagination') }}
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>


    {{-- detail member --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Detail member
                </div>
                <div class="modal-body" id="vdetail">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/member.js"></script>
    </x-slot:foot>
</x-admin.contents>
